/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities.behaviour;

import com.badlogic.gdx.ai.msg.MessageDispatcher;
import com.badlogic.gdx.math.Vector2;
import java.util.Random;
import technology.rocketjump.undermount.entities.behaviour.AttachedLightSourceBehaviour;
import technology.rocketjump.undermount.entities.behaviour.ItemBehaviour;
import technology.rocketjump.undermount.entities.components.BehaviourComponent;
import technology.rocketjump.undermount.entities.components.ProfessionsComponent;
import technology.rocketjump.undermount.entities.components.SteeringComponent;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.model.ai.goals.Goal;
import technology.rocketjump.undermount.entities.model.ai.goals.IdleGoal;
import technology.rocketjump.undermount.entities.model.ai.goals.exceptions.GoalException;
import technology.rocketjump.undermount.entities.model.ai.goals.exceptions.NoJobAvailableException;
import technology.rocketjump.undermount.entities.model.ai.goals.jobs.MoveAndPlaceItemGoal;
import technology.rocketjump.undermount.entities.model.ai.goals.jobs.PlaceItemGoal;
import technology.rocketjump.undermount.entities.model.ai.goals.jobs.WorkOnJobGoal;
import technology.rocketjump.undermount.entities.model.ai.goals.pathfinding.GoToLocationGoal;
import technology.rocketjump.undermount.entities.model.physical.humanoid.EquippedItemComponent;
import technology.rocketjump.undermount.entities.model.physical.humanoid.HaulingComponent;
import technology.rocketjump.undermount.entities.model.physical.humanoid.InventoryComponent;
import technology.rocketjump.undermount.gamecontext.GameContext;
import technology.rocketjump.undermount.mapping.model.TiledMap;
import technology.rocketjump.undermount.mapping.tile.MapTile;
import technology.rocketjump.undermount.misc.VectorUtils;
import technology.rocketjump.undermount.rooms.ItemAllocation;

public class HumanoidBehaviour
implements BehaviourComponent {
    private Goal currentGoal;
    private SteeringComponent steeringComponent;
    private MessageDispatcher messageDispatcher;
    private Entity parentEntity;
    private boolean workOnJobNext;
    private static final float MAX_IDLE_HOURS = 0.5f;

    @Override
    public HumanoidBehaviour clone(MessageDispatcher messageDispatcher, TiledMap tiledMap) {
        HumanoidBehaviour cloned = new HumanoidBehaviour();
        cloned.init(this.parentEntity, messageDispatcher, tiledMap);
        return cloned;
    }

    @Override
    public void init(Entity parentEntity, MessageDispatcher messageDispatcher, TiledMap areaMap) {
        this.messageDispatcher = messageDispatcher;
        this.parentEntity = parentEntity;
        this.steeringComponent = new SteeringComponent(messageDispatcher);
        this.steeringComponent.init(parentEntity.getId(), areaMap, parentEntity.getLocationComponent());
    }

    @Override
    public void update(float deltaTime, TiledMap areaMap) {
        if (this.currentGoal == null || this.currentGoal.isComplete()) {
            this.equipItem(null);
            this.currentGoal = this.newRandomGoal(areaMap);
        }
        try {
            this.currentGoal.update(deltaTime);
        }
        catch (NoJobAvailableException e) {
            this.currentGoal = new IdleGoal(this.parentEntity, 0.2f);
        }
        catch (GoalException e) {
            this.currentGoal = null;
            this.steeringComponent.destinationReached();
        }
        this.steeringComponent.update(deltaTime);
    }

    private void equipItem(Entity itemToEquip) {
        EquippedItemComponent equippedItemComponent = this.parentEntity.getOrCreateComponent(EquippedItemComponent.class);
        if (itemToEquip == null) {
            Entity currentItem = equippedItemComponent.clearEquippedItem();
            if (currentItem != null) {
                InventoryComponent inventoryComponent = this.parentEntity.getOrCreateComponent(InventoryComponent.class);
                inventoryComponent.addItem(currentItem);
            }
        } else {
            equippedItemComponent.setEquippedItem(itemToEquip, this.messageDispatcher);
        }
    }

    @Override
    public SteeringComponent getSteeringComponent() {
        return this.steeringComponent;
    }

    @Override
    public void infrequentUpdate(GameContext gameContext) {
        AttachedLightSourceBehaviour.infrequentUpdate(gameContext, this.parentEntity);
    }

    @Override
    public boolean isUpdateEveryFrame() {
        return true;
    }

    @Override
    public boolean isUpdateInfrequently() {
        return true;
    }

    @Override
    public boolean isJobAssignable() {
        return true;
    }

    private Goal newRandomGoal(TiledMap areaMap) {
        Entity hauledItem;
        Random random = new Random();
        if (this.parentEntity.getComponent(HaulingComponent.class) != null && (hauledItem = this.parentEntity.getComponent(HaulingComponent.class).getHauledItem()) != null) {
            ItemAllocation stockpileAllocation = ItemBehaviour.findStockpileAllocation(areaMap, hauledItem, this.parentEntity);
            MoveAndPlaceItemGoal moveAndPlaceItemGoal = new MoveAndPlaceItemGoal(this.parentEntity, this.messageDispatcher, areaMap, stockpileAllocation);
            if (stockpileAllocation == null) {
                moveAndPlaceItemGoal.getChildGoals().add(this.goToRandomLocationGoal(areaMap, random));
                moveAndPlaceItemGoal.getChildGoals().add(new PlaceItemGoal(this.parentEntity, this.messageDispatcher, null, areaMap));
            } else {
                moveAndPlaceItemGoal.getChildGoals().add(new GoToLocationGoal(this.parentEntity, VectorUtils.toVector(stockpileAllocation.getTargetPosition()), this.messageDispatcher, areaMap));
                moveAndPlaceItemGoal.getChildGoals().add(new PlaceItemGoal(this.parentEntity, this.messageDispatcher, stockpileAllocation, areaMap));
            }
            return moveAndPlaceItemGoal;
        }
        if (this.workOnJobNext) {
            this.workOnJobNext = false;
            return new WorkOnJobGoal(this.parentEntity, this.messageDispatcher, areaMap);
        }
        ProfessionsComponent professionsComponent = this.parentEntity.getComponent(ProfessionsComponent.class);
        int d100Roll = random.nextInt(100) + 1;
        if (d100Roll <= 10) {
            return new IdleGoal(this.parentEntity, random.nextFloat() * 0.5f);
        }
        if (d100Roll <= 70 && professionsComponent != null) {
            return new WorkOnJobGoal(this.parentEntity, this.messageDispatcher, areaMap);
        }
        return this.goToRandomLocationGoal(areaMap, random);
    }

    private Goal goToRandomLocationGoal(TiledMap areaMap, Random random) {
        Vector2 targetLocation = null;
        int attempts = 0;
        while (targetLocation == null && attempts < 16) {
            Vector2 worldPosition = this.parentEntity.getLocationComponent().getWorldPosition();
            MapTile randomCell = areaMap.getTile((int)Math.floor(worldPosition.x) + (random.nextInt(13) - 6), (int)Math.floor(worldPosition.y) + (random.nextInt(13) - 6));
            if (randomCell == null || !randomCell.isNavigable()) continue;
            targetLocation = randomCell.getWorldPositionOfCenter();
        }
        if (targetLocation == null) {
            return new IdleGoal(this.parentEntity, 0.1f);
        }
        return new GoToLocationGoal(this.parentEntity, targetLocation, this.messageDispatcher, areaMap);
    }

    public Goal getCurrentGoal() {
        return this.currentGoal;
    }

    public void setCurrentGoal(Goal newGoal) {
        this.currentGoal = newGoal;
    }

    public void clearCurrentGoal() {
        this.currentGoal = null;
    }

    public boolean isWorkOnJobNext() {
        return this.workOnJobNext;
    }

    public void setWorkOnJobNext(boolean workOnJobNext) {
        this.workOnJobNext = workOnJobNext;
    }
}

